/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.menu;

import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import dev.ftb.extendedexchange.menu.AbstractEXMenu;
import dev.ftb.extendedexchange.menu.IGuiButtonListener;
import dev.ftb.extendedexchange.network.NetworkHandler;
import dev.ftb.extendedexchange.network.PacketNotifyKnowledgeChange;
import dev.ftb.extendedexchange.util.EXUtils;
import java.math.BigInteger;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.config.ProjectEConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTableMenu
extends AbstractEXMenu<AbstractEMCBlockEntity>
implements IGuiButtonListener {
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    protected final Player player;
    protected final IKnowledgeProvider provider;

    public AbstractTableMenu(MenuType<?> type, int windowId, Inventory invPlayer, BlockPos pos) {
        super(type, windowId, invPlayer, pos);
        this.player = invPlayer.f_35978_;
        this.provider = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(this.player.m_142081_());
    }

    @Override
    @NotNull
    protected Class<AbstractEMCBlockEntity> blockEntityClass() {
        return AbstractEMCBlockEntity.class;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        switch (tag) {
            case "learn": {
                this.learnItem();
                break;
            }
            case "unlearn": {
                this.unlearnItem();
                break;
            }
            case "burn": {
                this.burnItem(shiftHeld);
            }
        }
        if (tag.startsWith("extract:")) {
            this.tryExtractItem(tag.substring(8), shiftHeld);
        }
    }

    private void tryExtractItem(String itemId, boolean pullStack) {
        ResourceLocation id = new ResourceLocation(itemId);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item != null && item != Items.f_41852_) {
            int available;
            BigInteger availableEMC = this.provider.getEmc();
            BigInteger emc = BigInteger.valueOf(ProjectEAPI.getEMCProxy().getValue(item));
            if (emc.equals(BigInteger.ZERO)) {
                return;
            }
            BigInteger bigAvail = availableEMC.divide(emc);
            int n = available = bigAvail.compareTo(MAX_INT) >= 0 ? Integer.MAX_VALUE : bigAvail.intValue();
            if (available > 0) {
                ItemStack stack = new ItemStack((ItemLike)item);
                BigInteger cost = BigInteger.ZERO;
                if (pullStack) {
                    stack.m_41764_(Math.min(stack.m_41741_(), available));
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)stack);
                    cost = emc.multiply(BigInteger.valueOf(stack.m_41613_()));
                } else if (this.m_142621_().m_41619_()) {
                    this.m_142503_(stack);
                    cost = emc;
                } else if (this.m_142621_().m_41613_() < this.m_142621_().m_41741_()) {
                    this.m_142621_().m_41769_(1);
                    cost = emc;
                }
                if (!cost.equals(BigInteger.ZERO)) {
                    this.provider.setEmc(availableEMC.subtract(cost));
                    this.provider.syncEmc((ServerPlayer)this.player);
                }
            }
        }
    }

    private void tryAddKnowledge(ItemStack stack) {
        if (EXUtils.addKnowledge(this.player, this.provider, stack) == EXUtils.KnowledgeAddResult.ADDED) {
            this.provider.syncKnowledgeChange((ServerPlayer)this.player, ItemInfo.fromStack((ItemStack)stack), true);
            NetworkHandler.sendToPlayer((ServerPlayer)this.player, new PacketNotifyKnowledgeChange());
        }
    }

    private void burnItem(boolean storedEMConly) {
        ItemStack cursorStack = this.m_142621_();
        if (!cursorStack.m_41619_()) {
            ItemStack fixed;
            if (storedEMConly && cursorStack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).isPresent()) {
                cursorStack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(handler -> {
                    long extracted = handler.extractEmc(cursorStack, handler.getMaximumEmc(cursorStack), IEmcStorage.EmcAction.EXECUTE);
                    this.provider.setEmc(this.provider.getEmc().add(BigInteger.valueOf(extracted)));
                    this.provider.syncEmc((ServerPlayer)this.player);
                });
            } else if (ProjectEAPI.getEMCProxy().hasValue(cursorStack) && this.isItemValid(fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)cursorStack)).createStack())) {
                this.tryAddKnowledge(fixed);
                long toAdd = (long)((double)(ProjectEAPI.getEMCProxy().getValue(fixed) * (long)cursorStack.m_41613_()) * ProjectEConfig.server.difficulty.covalenceLoss.get());
                this.provider.setEmc(this.provider.getEmc().add(BigInteger.valueOf(toAdd)));
                this.provider.syncEmc((ServerPlayer)this.player);
                this.m_142503_(ItemStack.f_41583_);
            }
        }
    }

    private void learnItem() {
        if (!this.m_142621_().m_41619_()) {
            ItemStack fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)this.m_142621_())).createStack();
            this.tryAddKnowledge(fixed);
        }
    }

    private void unlearnItem() {
        ItemStack fixed;
        if (!this.m_142621_().m_41619_() && this.provider.removeKnowledge(fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)this.m_142621_())).createStack())) {
            this.provider.syncKnowledgeChange((ServerPlayer)this.player, ItemInfo.fromStack((ItemStack)fixed), false);
            NetworkHandler.sendToPlayer((ServerPlayer)this.player, new PacketNotifyKnowledgeChange());
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack stack = slot.m_7993_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (index >= this.playerSlotsStart && !stack.m_41619_()) {
                if (!ProjectEAPI.getEMCProxy().hasValue(stack)) {
                    return ItemStack.f_41583_;
                }
                ItemStack fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)stack)).createStack();
                if (!this.isItemValid(fixed)) {
                    return ItemStack.f_41583_;
                }
                this.tryAddKnowledge(fixed);
                long toAdd = (long)((double)(ProjectEAPI.getEMCProxy().getValue(stack) * (long)stack.m_41613_()) * ProjectEConfig.server.difficulty.covalenceLoss.get());
                this.provider.setEmc(this.provider.getEmc().add(BigInteger.valueOf(toAdd)));
                this.provider.syncEmc(serverPlayer);
                slot.m_5852_(ItemStack.f_41583_);
                return fixed;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean isItemValid(ItemStack stack) {
        return true;
    }

    public IKnowledgeProvider getProvider() {
        return this.provider;
    }
}

